package gov.va.med.mhv.usermgmt.bizobj;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;

import com.agitar.lib.ConcreteMock;
import com.agitar.lib.MockUtils;

public abstract class AgMockPatientBO extends PatientBaseBO implements ConcreteMock {
	
	public AgMockPatientBO() {
		MockUtils.doOriginal();
	}

	static {
		// if this block is left without any executable code, the compiler will omit it
		// and the static initializer of the real class will be used
		MockUtils.doNothing();
	}

	/**
	 * @see gov.va.med.mhv.usermgmt.bizobj.PatientBaseBO#getFacilitys()
	 */
	public Set getFacilitys() {
		Set facilitySet = null;
		boolean returnFacilities = MockUtils.getRandom().nextBoolean();
		if (returnFacilities) {
			int numberOfFacilities = MockUtils.getRandom().nextInt(10);
			facilitySet = new HashSet((int)(numberOfFacilities * 1.25));
			for (int i = 0; i < numberOfFacilities; i++) {
				FacilityBO facility = new FacilityBO();
				FacilityInfoBO facilityInfoBO = new FacilityInfoBO();
				facility.setFacilityInfo(facilityInfoBO);
				facilitySet.add(facility);
			}
			
		}
		
		return facilitySet;
	}

}
